import pytest
from min import Min

def test_find_min_with_integers():
    assert Min.find_min([3, 1, 4, 1, 5, 9, 2]) == 1

def test_find_min_with_strings():
    assert Min.find_min(["apple", "banana", "cherry"]) == "apple"

def test_find_min_with_null_list():
    with pytest.raises(ValueError, match="List is null"):
        Min.find_min(None)

def test_find_min_with_empty_list():
    with pytest.raises(ValueError, match="List is empty"):
        Min.find_min([])

def test_find_min_with_none_list():
    with pytest.raises(ValueError, match="List contains null element"):
        Min.find_min([None, None, None])

def test_find_min_with_none_element():
    with pytest.raises(ValueError, match="List contains null element"):
        Min.find_min([3, 1, None, 4])

def test_find_min_with_non_comparable_elements():
    with pytest.raises(TypeError, match="List elements are not mutually comparable"):
        Min.find_min([3, "apple", 4])

def test_find_min_with_mixed_types():
    with pytest.raises(TypeError, match="List elements are not mutually comparable"):
        Min.find_min([3, 2.0, 4])