from typing import List, TypeVar, Any

T = TypeVar('T')

class Min:
    @staticmethod
    def find_min(lst: List[T]) -> T:
        if lst is None:
            raise ValueError("List is null")
        
        if len(lst) == 0:
            raise ValueError("List is empty")
        
        min_element = lst[0]
        for element in lst:
            if element is None:
                raise ValueError("List contains null element")
            if not isinstance(element, type(min_element)):
                raise TypeError("List elements are not mutually comparable")
            if element < min_element:
                min_element = element

        return min_element