from pytest_assume import assume
import pytest
from copy import deepcopy

@pytest.mark.parametrize("some_set, str_val", [
    ({"a", "b", "c"}, "a"),
    ({"apple", "banana", "cherry"}, "banana"),
    ({"x", "y", "z"}, "y"),
    ({"foo", "bar"}, "bar"),
    (set(), ""),
])

def test_remove_then_add_does_not_change_set(some_set, str_val):
    # Assume condition
    with assume: some_set is not None
    with assume: str_val in some_set

    # Act
    copy = deepcopy(some_set)
    copy.remove(str_val)
    copy.add(str_val)

    # Assert
    assert some_set == copy, f"Set modification test failed for set {some_set} with string {str_val}"