import pytest
from jelly_bean import JellyBean, get_sample_bag

def test_taste_each_flavor():
    bag = get_sample_bag()
    flavors = {bean.flavor for bean in bag}
    expected_flavors = {"Lemon",  "Pistachio", "Cantaloupe", "Pear", "Tangerine", "Apricot"}

    assert expected_flavors.issubset(flavors), f"Expected flavors not all tasted: {expected_flavors - flavors}"


def test_taste_each_color():
    bag = get_sample_bag()
    colors = {bean.color for bean in bag}
    expected_colors = {"Yellow", "Green", "Orange", "White"}
    
    assert expected_colors.issubset(colors), f"Expected colors not all tasted: {expected_colors - colors}"