import pytest
from jelly_bean import JellyBean

T1 = [
    JellyBean("Lemon", "Yellow"),
    JellyBean("Lemon", "Yellow"),
    JellyBean("Lemon", "Yellow"),
    JellyBean("Pistachio", "Green"),
    JellyBean("Cantaloupe", "Orange"),
    JellyBean("Cantaloupe", "Orange"),
    JellyBean("Pear", "White"),
    JellyBean("Tangerine", "Orange"),
    JellyBean("Apricot", "Yellow"),
    JellyBean("Apricot", "Yellow"),
    JellyBean("Apricot", "Yellow"),
    JellyBean("Apricot", "Yellow"),
]

T2 = [
    JellyBean("Lemon", "Yellow"),
    JellyBean("Pistachio", "Green"),
    JellyBean("Pistachio", "Green"),
    JellyBean("Pear", "White"),
    JellyBean("Tangerine", "Orange"),
    JellyBean("Tangerine", "Orange"),
    JellyBean("Tangerine", "Orange"),
]


def compute_coverage(covered, total):
    return (len(covered) / len(total)) * 100


def test_T1_flavor_criterion():
    flavors = {bean.flavor for bean in T1}
    expected_flavors = {"Lemon", "Pistachio", "Cantaloupe", "Pear", "Tangerine", "Apricot"}
    covered_percentage = compute_coverage(flavors, expected_flavors)
    print(f"T1 Flavor Coverage: {covered_percentage:.2f}%")
    assert expected_flavors.issubset(flavors), f"T1 does not satisfy the flavor criterion: {expected_flavors - flavors}"


def test_T2_flavor_criterion():
    flavors = {bean.flavor for bean in T2}
    expected_flavors = {"Lemon", "Pistachio", "Cantaloupe", "Pear", "Tangerine", "Apricot"}
    covered_percentage = compute_coverage(flavors, expected_flavors)
    print(f"T2 Flavor Coverage: {covered_percentage:.2f}%")
    assert expected_flavors.issubset(flavors), f"T2 does not satisfy the flavor criterion: {expected_flavors - flavors}"


def test_T2_color_criterion():
    colors = {bean.color for bean in T2}
    expected_colors = {"Yellow", "Green", "Orange", "White"}
    covered_percentage = compute_coverage(colors, expected_colors)
    print(f"T2 Color Coverage: {covered_percentage:.2f}%")
    assert expected_colors.issubset(colors), f"T2 does not satisfy the color criterion: {expected_colors - colors}"


if __name__ == "__main__":
    pytest.main(["-s", "test_flavor_color_criteria.py", "--cov=.", "--cov-report=term-missing"])