import random

class GuessNumberGame:
    def __init__(self):
        self.computer_number = random.randint(0, 9) 
        self.guess_count = 0

    def guess(self, user_guess):
        self.guess_count += 1
        if user_guess == self.computer_number:
            return True
        return False
    
    def reset(self):
        self.computer_number = random.randint(0, 9)


def gameplay():
    game = GuessNumberGame()
    while True:
        try:
            user_input = input("Guess a number between 0 and 9: ")
            user_guess = int(user_input)
            if user_guess < 0 or user_guess > 9:
                print("Please enter a number between 0 and 9.")
                continue
        except ValueError:
            print("Invalid input. Please enter an integer between 0 and 9.")
            continue

        if game.guess(user_guess):
            print(f"Congratulations! You guessed the correct number: {game.computer_number} in {game.guess_count} tries.")
            
            game.reset()

            break
        else:
            print(f"Wrong guess. Try again!")


if __name__ == "__main__":
    gameplay()