/*
 * The "sum of squares" is being interpreted as each number being squared and then added together, as opposed to sum of
 * squares in statistics.
 */

public class Twentyone
{
	public static void main(String[] args)
	{
		if (args.length != 1)
		{
			System.out.println("Please enter exactly 1 argument");
			System.exit(1);
		}
	
		float temp = Float.parseFloat(args[0]);
		if (temp <= 1)
		{
			System.out.println("Number must be greater than 1");
			System.exit(1);
		}
		
		int n = (int) temp;
		int sum = n * (n + 1) * (2*n + 1) / 6;
		System.out.println(sum);
	}
}
