public class Eighteen
{
	// A sightly different bubble sort
	public static void bubbleSort(float[] list)
	{
		float temp;
		int max_index;
		int end = list.length - 1;
		for (int i = 0; i < list.length; i++)
		{
			max_index = 0;
			for (int j = 1; j <= end; j++)
			{
				if (list[j] > list[max_index])
					max_index = j;
			}
			temp = list[end];
			list[end] = list[max_index];
			list[max_index] = temp;
			end--;
		}
	}
	
	public static void main(String[] args)
	{
		if (args.length != 10)
		{
			System.out.println("Please enter exactly 10 arguments");
			System.exit(1);
		}
		float[] list = new float[10];
		for (int i = 0; i < 10; i++)
		{
			list[i] = Float.parseFloat(args[i]);
			if (list[i] < 0 || list[i] > 1)
			{
				System.out.println("Element at position " + i + " is not in the interval [0, 1]");
				System.exit(0);
			}
		}
		
		// Calculate the mean
		float sum = 0;
		for (int i = 0; i < 10; i++)
			sum += list[i];
		sum /= 10.0;

		// Sort the list to obtain the median
		bubbleSort(list);
		float median = (list[4] + list[5]) / 2;

		System.out.println("Mean: " + sum + " Median: " + median);
	}
}
